/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client;

import com.corosus.watut.client.ParticleRenderTypeOld;
import com.corosus.watut.particle.ParticleRotating;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_10209;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_133;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2394;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4089;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_733;
import net.minecraft.class_765;
import net.minecraft.class_7654;
import net.minecraft.class_7766;
import net.minecraft.class_9801;
import org.slf4j.Logger;

public class CustomParticleEngine
implements class_3302 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_7654 PARTICLE_LISTER = class_7654.method_45114((String)"particles");
    private static final class_2960 PARTICLES_ATLAS_INFO = class_2960.method_60654((String)"particles");
    private static final int MAX_PARTICLES_PER_LAYER = 16384;
    private static final List<ParticleRenderTypeOld> RENDER_ORDER = ImmutableList.of();
    protected class_638 level;
    private final Map<ParticleRenderTypeOld, Queue<ParticleRotating>> particles = Maps.newTreeMap(CustomParticleEngine.makeParticleRenderTypeOldComparator(RENDER_ORDER));
    private final Queue<class_733> trackingEmitters = Queues.newArrayDeque();
    private final class_1060 textureManager;
    private final class_5819 random = class_5819.method_43047();
    private final Map<class_2960, class_707<?>> providers = new HashMap();
    private final Queue<ParticleRotating> particlesToAdd = Queues.newArrayDeque();
    private final Map<class_2960, MutableSpriteSet> spriteSets = Maps.newHashMap();
    public final class_1059 textureAtlas;
    private final Object2IntOpenHashMap<class_5878> trackedParticleCounts = new Object2IntOpenHashMap();

    public CustomParticleEngine(class_638 p_107299_, class_1060 p_107300_) {
        this.textureAtlas = new class_1059(class_1059.field_17898);
        this.level = p_107299_;
        this.textureManager = p_107300_;
    }

    public static Comparator<ParticleRenderTypeOld> makeParticleRenderTypeOldComparator(List<ParticleRenderTypeOld> renderOrder) {
        Comparator<ParticleRenderTypeOld> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderTypeOld)typeOne, (ParticleRenderTypeOld)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 barrier, class_3300 manager, Executor backgroundExecutor, Executor gameExecutor) {
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.method_45113(manager), backgroundExecutor).thenCompose(p_247914_ -> {
            ArrayList list = new ArrayList(p_247914_.size());
            p_247914_.forEach((p_247903_, p_247904_) -> {
                class_2960 resourcelocation = PARTICLE_LISTER.method_45115(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(class_2960 id, Optional<List<class_2960>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (class_3298)p_247904_));
                }, backgroundExecutor));
            });
            return class_156.method_33791(list);
        });
        CompletionStage completablefuture1 = class_7766.method_45837((class_1059)this.textureAtlas).method_52849(manager, PARTICLES_ATLAS_INFO, 0, backgroundExecutor).thenCompose(class_7766.class_7767::method_45845);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((class_3302.class_4045)barrier).method_18352(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$6((CompletableFuture)completablefuture1, (CompletableFuture)completablefuture, arg_0), gameExecutor);
    }

    public void close() {
        this.textureAtlas.method_4601();
    }

    private Optional<List<class_2960>> loadParticleDescription(class_2960 p_250648_, class_3298 p_248793_) {
        Optional<List<class_2960>> optional;
        block9: {
            if (!this.spriteSets.containsKey(p_250648_)) {
                LOGGER.debug("Redundant texture list for particle: {}", (Object)p_250648_);
                return Optional.empty();
            }
            BufferedReader reader = p_248793_.method_43039();
            try {
                class_4089 particledescription = class_4089.method_18828((JsonObject)class_3518.method_15255((Reader)reader));
                optional = Optional.of(particledescription.method_18826());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load description for particle " + String.valueOf(p_250648_), ioexception);
                }
            }
            ((Reader)reader).close();
        }
        return optional;
    }

    public void add(ParticleRotating p_107345_) {
        Optional optional = p_107345_.method_34019();
        if (optional.isPresent()) {
            if (this.hasSpaceInParticleLimit((class_5878)optional.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount((class_5878)optional.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.particles.forEach((p_288249_, p_288250_) -> this.tickParticleList((Collection<ParticleRotating>)p_288250_));
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (class_733 trackingemitter : this.trackingEmitters) {
                trackingemitter.method_3070();
                if (trackingemitter.method_3086()) continue;
                list.add(trackingemitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            ParticleRotating particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.getRenderTypeOld(), p_107347_ -> EvictingQueue.create((int)16384)).add(particle);
            }
        }
    }

    private void tickParticleList(Collection<ParticleRotating> p_107385_) {
        if (!p_107385_.isEmpty()) {
            Iterator<ParticleRotating> iterator = p_107385_.iterator();
            while (iterator.hasNext()) {
                class_703 particle = (class_703)iterator.next();
                this.tickParticle(particle);
                if (particle.method_3086()) continue;
                particle.method_34019().ifPresent(p_172289_ -> this.updateCount((class_5878)p_172289_, -1));
                iterator.remove();
            }
        }
    }

    private void updateCount(class_5878 p_172282_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_172282_, p_172283_);
    }

    private void tickParticle(class_703 p_107394_) {
        try {
            p_107394_.method_3070();
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Ticking Particle");
            class_129 crashreportcategory = crashreport.method_562("Particle being ticked");
            crashreportcategory.method_577("Particle", () -> ((class_703)p_107394_).toString());
            crashreportcategory.method_577("Particle Type", () -> ((class_3999)p_107394_.method_18122()).toString());
            throw new class_148(crashreport);
        }
    }

    @Deprecated
    public void render(class_4587 p_107337_, class_4597.class_4598 p_107338_, class_765 p_107339_, class_4184 p_107340_, float p_107341_) {
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_);
    }

    public void render(class_765 lightTexture, class_4184 camera, float partialTick) {
        if (lightTexture != null) {
            lightTexture.method_3316();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        this.render(lightTexture, camera, partialTick, false);
        this.render(lightTexture, camera, partialTick, true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        if (lightTexture != null) {
            lightTexture.method_3315();
        }
    }

    public void render(class_765 lightTexture, class_4184 camera, float partialTick, boolean pickupParticleMode) {
        for (ParticleRenderTypeOld particlerendertype : this.particles.keySet()) {
            if (!pickupParticleMode ? particlerendertype == ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL : particlerendertype != ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL) continue;
            Queue<ParticleRotating> queue = this.particles.get(particlerendertype);
            if (queue == null || queue.isEmpty()) continue;
            RenderSystem.setShader((class_10156)class_10142.field_53874);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = particlerendertype.begin(tesselator, this.textureManager);
            if (bufferbuilder != null) {
                for (class_703 class_7032 : queue) {
                    try {
                        class_7032.method_3074((class_4588)bufferbuilder, camera, partialTick);
                    }
                    catch (Throwable throwable) {
                        class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering Particle");
                        class_129 crashreportcategory = crashreport.method_562("Particle being rendered");
                        crashreportcategory.method_577("Particle", () -> ((class_703)class_7032).toString());
                        crashreportcategory.method_577("Particle Type", (class_133)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((ParticleRenderTypeOld)particlerendertype));
                        throw new class_148(crashreport);
                    }
                }
                class_9801 meshdata = bufferbuilder.method_60794();
                if (meshdata != null) {
                    class_286.method_43433((class_9801)meshdata);
                }
            }
            RenderSystem.enableCull();
        }
    }

    public void setLevel(class_638 p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean hasSpaceInParticleLimit(class_5878 p_172280_) {
        return this.trackedParticleCounts.getInt((Object)p_172280_) < p_172280_.method_34045();
    }

    private void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }

    private /* synthetic */ void lambda$reload$6(CompletableFuture completablefuture1, CompletableFuture completablefuture, Void p_372548_) {
        this.clearParticles();
        class_3695 profilerfiller = class_10209.method_64146();
        profilerfiller.method_15396("upload");
        class_7766.class_7767 spriteloader$preparations = (class_7766.class_7767)completablefuture1.join();
        this.textureAtlas.method_45848(spriteloader$preparations);
        profilerfiller.method_15405("bindSpriteSets");
        HashSet set = new HashSet();
        class_1058 textureatlassprite = spriteloader$preparations.comp_1043();
        ((List)completablefuture.join()).forEach(p_247911_ -> {
            Optional<List<class_2960>> optional = p_247911_.sprites();
            if (!optional.isEmpty()) {
                ArrayList<class_1058> list = new ArrayList<class_1058>();
                for (class_2960 resourcelocation : optional.get()) {
                    class_1058 textureatlassprite1 = (class_1058)spriteloader$preparations.comp_1044().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(p_247911_.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(class_2960::toString).collect(Collectors.joining(",")));
        }
        profilerfiller.method_15407();
    }

    static class MutableSpriteSet
    implements class_4002 {
        private List<class_1058> sprites;

        MutableSpriteSet() {
        }

        public class_1058 method_18138(int p_107413_, int p_107414_) {
            return this.sprites.get(p_107413_ * (this.sprites.size() - 1) / p_107414_);
        }

        public class_1058 method_18139(class_5819 p_233889_) {
            return this.sprites.get(p_233889_.method_43048(this.sprites.size()));
        }

        public void rebind(List<class_1058> p_107416_) {
            this.sprites = ImmutableList.copyOf(p_107416_);
        }
    }

    @FunctionalInterface
    public static interface SpriteParticleRegistration<T extends class_2394> {
        public class_707<T> create(class_4002 var1);
    }
}

