/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.serverbound;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;

public class PlayerStatePacket
implements Packet<ServerPacketTcpHandler> {
    private boolean voiceDisabled;
    private boolean microphoneMuted;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.voiceDisabled = in.readBoolean();
        this.microphoneMuted = in.readBoolean();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeBoolean(this.voiceDisabled);
        out.writeBoolean(this.microphoneMuted);
    }

    @Override
    public void handle(ServerPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerStatePacket(boolean voiceDisabled, boolean microphoneMuted) {
        this.voiceDisabled = voiceDisabled;
        this.microphoneMuted = microphoneMuted;
    }

    public PlayerStatePacket() {
    }

    public String toString() {
        return "PlayerStatePacket(voiceDisabled=" + this.isVoiceDisabled() + ", microphoneMuted=" + this.isMicrophoneMuted() + ")";
    }

    public boolean isVoiceDisabled() {
        return this.voiceDisabled;
    }

    public boolean isMicrophoneMuted() {
        return this.microphoneMuted;
    }
}

