/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.api.util.AudioUtil;

public final class CompressorFilter
implements AudioFilter {
    private static final float SLOPE = 0.9f;
    private static final float OUTPUT_GAIN = AudioUtil.dbToMul(0.0f);
    private static final float ATTACK_TIME = 6.0f;
    private static final float RELEASE_TIME = 60.0f;
    private final int sampleRate;
    private final ConfigEntry<Boolean> activeEntry;
    private final IntConfigEntry thresholdEntry;
    private float[] envelopeBuf = new float[0];
    private float envelope;

    @Override
    @NotNull
    public String getName() {
        return "compressor";
    }

    @Override
    public short[] process(@NotNull AudioFilterContext context, short[] samples) {
        float[] floatSamples = AudioUtil.shortsToFloatsRange(samples);
        this.analyzeEnvelope(floatSamples);
        this.compress(floatSamples);
        return AudioUtil.floatsRangeToShort(floatSamples);
    }

    @Override
    public boolean isEnabled() {
        return this.activeEntry.value();
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    public synchronized void compress(float[] samples) {
        float compressorThreshold = ((Integer)this.thresholdEntry.value()).intValue();
        int i = 0;
        while (i < samples.length) {
            float envDB = AudioUtil.mulToDB(this.envelopeBuf[i]);
            float compressorGain = 0.9f * (compressorThreshold - envDB);
            compressorGain = AudioUtil.dbToMul(Math.min(0.0f, compressorGain));
            int n = i++;
            samples[n] = samples[n] * (compressorGain * OUTPUT_GAIN);
        }
    }

    private synchronized void analyzeEnvelope(float[] samples) {
        this.envelopeBuf = new float[samples.length];
        float attackGain = AudioUtil.gainCoefficient(this.sampleRate, 0.006f);
        float releaseGain = AudioUtil.gainCoefficient(this.sampleRate, 0.06f);
        float env = this.envelope;
        for (int i = 0; i < samples.length; ++i) {
            float envIn = Math.abs(samples[i]);
            env = env < envIn ? envIn + attackGain * (env - envIn) : envIn + releaseGain * (env - envIn);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], env);
        }
        this.envelope = this.envelopeBuf[samples.length - 1];
    }

    public CompressorFilter(int sampleRate, ConfigEntry<Boolean> activeEntry, IntConfigEntry thresholdEntry) {
        this.sampleRate = sampleRate;
        this.activeEntry = activeEntry;
        this.thresholdEntry = thresholdEntry;
    }
}

