/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text.minimessage.tag.standard;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.text.format.NamedTextColor;
import su.plo.slib.libs.adventure.adventure.text.format.ShadowColor;
import su.plo.slib.libs.adventure.adventure.text.format.StyleGetter;
import su.plo.slib.libs.adventure.adventure.text.format.TextColor;
import su.plo.slib.libs.adventure.adventure.text.minimessage.Context;
import su.plo.slib.libs.adventure.adventure.text.minimessage.ParsingException;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.serializer.StyleClaim;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.Tag;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.standard.ColorTagResolver;

final class ShadowColorTag {
    private static final String SHADOW_COLOR = "shadow";
    private static final String SHADOW_NONE = "!shadow";
    private static final float DEFAULT_ALPHA = 0.25f;
    static final TagResolver RESOLVER = TagResolver.resolver(SerializableResolver.claimingStyle("shadow", ShadowColorTag::create, StyleClaim.claim("shadow", StyleGetter::shadowColor, ShadowColorTag::emit)), TagResolver.resolver("!shadow", Tag.styling(ShadowColor.none())));

    static Tag create(@NotNull ArgumentQueue args2, @NotNull Context ctx) throws ParsingException {
        ShadowColor color;
        String colorString = args2.popOr("Expected to find a color parameter: #RRGGBBAA").lowerValue();
        if (colorString.startsWith("#") && colorString.length() == 9) {
            color = ShadowColor.fromHexString(colorString);
            if (color == null) {
                throw ctx.newException(String.format("Unable to parse a shadow color from '%s'. Please use #RRGGBBAA formatting.", colorString));
            }
        } else {
            TextColor text = ColorTagResolver.resolveColor(colorString, ctx);
            float alpha = args2.hasNext() ? (float)args2.pop().asDouble().orElseThrow(() -> ctx.newException("Number was expected to be a double")) : 0.25f;
            color = ShadowColor.shadowColor(text, (int)(alpha * 255.0f));
        }
        return Tag.styling(color);
    }

    static void emit(@NotNull ShadowColor color, @NotNull TokenEmitter emitter) {
        if (ShadowColor.none().equals(color)) {
            emitter.tag(SHADOW_NONE);
            return;
        }
        emitter.tag(SHADOW_COLOR);
        @Nullable NamedTextColor possibleMatch = NamedTextColor.namedColor(TextColor.color(color).value());
        if (possibleMatch != null) {
            emitter.argument(NamedTextColor.NAMES.key(possibleMatch)).argument(Float.toString((float)color.alpha() / 255.0f));
        } else {
            emitter.argument(color.asHexString());
        }
    }

    private ShadowColorTag() {
    }
}

