/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.FBO;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.SaveTexture;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidCuda;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.EmptyTextureShader;
import net.diebuddies.render.shader.GaussianDepthBlurEffect;
import net.diebuddies.render.shader.LiquidShader;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.class_10156;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class LiquidDeferredRenderer {
    private MainRenderer mainRenderer;
    private static FBO depthFBO;
    private static LiquidShader liquidShader;
    private static EmptyTextureShader emptyTextureShader;
    private static VAO liquidVAO;
    private static VAO emptyVAO;
    private static Texture liquidDepthCopy;
    private static Texture depth;
    private static GaussianDepthBlurEffect blurEffect;
    private static float[] liquidpos;
    private static float[] liquidposnew;
    private static int[] viewport;
    private int liquidCount;
    private int mcEntityLocation;
    private int depthActiveTexture = 25;
    private Vector4f waterBounds = new Vector4f();
    private Vector2f waterMidCoord = new Vector2f();
    private int waterID;
    private Vector3d offsetCamera = new Vector3d(0.0, 0.0, 0.0);
    private Matrix4f tmpMatrix = new Matrix4f();

    public LiquidDeferredRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, class_638 level, Matrix4fStack matrixStackIn, class_243 cameraPos) {
    }

    private void renderInstancedLiquidSpheres(PhysicsWorld physics, class_638 level, Matrix4fStack matrixStackIn, class_243 cameraPos) {
        int location;
        this.bindLiquidsShader();
        class_5944 shaderInstance = RenderSystem.getShader();
        this.initRenderingStates(level, shaderInstance, true);
        this.setupLiquidsRendering(physics, level, shaderInstance, this.waterID);
        RenderSystem.enableCull();
        if (!(StarterClient.optifabric && Optifine.isUsingShadersNoInternal() || (location = shaderInstance.field_29470.method_35660()) == -1)) {
            GL32C.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)matrixStackIn.get(MainRenderer.matrixBuffer));
        }
        if (StarterClient.iris) {
            Iris.setNormalMatrix(shaderInstance, (Matrix4f)matrixStackIn);
        }
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 - offset.x, cameraPos.field_1351 - offset.y, cameraPos.field_1350 - offset.z);
        int shaderId = GL32C.glGetInteger((int)35725);
        int cameraLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_liquidCameraPos");
        int renderPercentLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_renderPercent");
        if (cameraLocation != -1) {
            GL32C.glUniform3f((int)cameraLocation, (float)((float)this.offsetCamera.x), (float)((float)this.offsetCamera.y), (float)((float)this.offsetCamera.z));
        }
        if (renderPercentLocation != -1) {
            GL32C.glUniform1f((int)renderPercentLocation, (float)((float)physics.getRenderPercent()));
        }
        liquidVAO.renderInstanced(this.liquidCount);
    }

    private void renderLiquidDataIntoTexture(PhysicsWorld physics, class_638 level, class_243 cameraPos) {
        int drawFboBoundBefore = GL32C.glGetInteger((int)36006);
        int readFboBoundBefore = GL32C.glGetInteger((int)36010);
        boolean create = depthFBO == null || liquidDepthCopy.getWidth() != viewport[2] || liquidDepthCopy.getHeight() != viewport[3];
        liquidDepthCopy = SaveTexture.copyFramebufferDepthTexture(liquidDepthCopy);
        if (create) {
            if (depthFBO != null) {
                depthFBO.destroy(false);
                depth.destroy();
                blurEffect.destroy();
            }
            blurEffect = new GaussianDepthBlurEffect(8.0, 20);
            depthFBO = new FBO();
            depth = Texture.createTexture(viewport[2], viewport[3], 33326, 6403, 5126);
            depthFBO.attachColorBuffer(depth);
            depthFBO.attachDepthBuffer(liquidDepthCopy);
            depthFBO.checkError();
            blurEffect.setImage(depthFBO);
        }
        liquidShader.bind();
        depthFBO.bind();
        liquidVAO.bind();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clear((int)16384);
        RenderSystem.disableBlend();
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 - offset.x, cameraPos.field_1351 - offset.y, cameraPos.field_1350 - offset.z);
        LiquidShader shader = liquidShader;
        shader.bind();
        shader.uploadMatrix(shader.getUniformLocation("ModelViewMat"), RenderSystem.getModelViewMatrix());
        shader.uploadMatrix(shader.getUniformLocation("ProjMat"), RenderSystem.getProjectionMatrix());
        shader.setUniform3(shader.getUniformLocation("LiquidCameraPos"), (float)this.offsetCamera.x, (float)this.offsetCamera.y, (float)this.offsetCamera.z);
        double renderPercent = physics.getRenderPercent();
        shader.setUniform1(shader.getUniformLocation("RenderPercent"), (float)renderPercent);
        liquidVAO.renderInstanced(this.liquidCount);
        for (int i = 0; i < ConfigClient.cudaLiquidsBlurPasses; ++i) {
            blurEffect.render(emptyVAO);
        }
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        GL32C.glBindFramebuffer((int)36009, (int)drawFboBoundBefore);
        GL32C.glBindFramebuffer((int)36008, (int)readFboBoundBefore);
        this.bindLiquidsShader();
        class_5944 shaderInstance = RenderSystem.getShader();
        this.initRenderingStates(level, shaderInstance, false);
        this.setupLiquidsRendering(physics, level, shaderInstance, this.waterID);
        emptyVAO.renderEmptyTriangle();
    }

    private void bindLiquidsShader() {
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (Iris.liquidShadowShader != null) {
                    RenderSystem.setShader((class_5944)Iris.liquidShadowShader);
                    this.mainRenderer.setupShader(Iris.liquidShadowShader);
                }
            } else if (Iris.liquidShader != null) {
                RenderSystem.setShader((class_5944)Iris.liquidShader);
                this.mainRenderer.setupShader(Iris.liquidShader);
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            RenderSystem.setShader((class_10156)PhysicsShaders.LIQUID_COMPOSITE);
            this.mainRenderer.setupShader(RenderSystem.getShader());
        }
    }

    private void initRenderingStates(class_638 level, class_5944 shader, boolean shadowPass) {
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib3f((int)Data.NORMAL.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib3f((int)Data.NORMAL_SHADER.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        int color = class_1163.method_4961((class_1920)level, (class_2338)class_310.method_1551().field_1724.method_24515());
        GL32C.glVertexAttrib4f((int)Data.COLOR_SHADER.getAttribute(), (float)Pack.getRed(color), (float)Pack.getGreen(color), (float)Pack.getBlue(color), (float)1.0f);
        GL32C.glVertexAttribI2i((int)Data.LIGHT_SHADER.getAttribute(), (int)240, (int)240);
        GL32C.glVertexAttrib2f((int)Data.TEX_COORD_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
        if (StarterClient.iris) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.mcEntityLocation = GL20.glGetAttribLocation((int)RenderSystem.getShader().method_1270(), (CharSequence)"mc_Entity");
            if (this.mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)this.mcEntityLocation, (float)Iris.getMaterialID(class_2246.field_10382.method_9564()), (float)1.0f, (float)-1.0f, (float)-1.0f);
            }
        } else if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.mcEntityLocation = Optifine.isUsingShadersNoInternal() ? 11 : GL20.glGetAttribLocation((int)RenderSystem.getShader().method_1270(), (CharSequence)"mc_Entity");
            if (this.mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)this.mcEntityLocation, (float)Optifine.getMaterialID(class_2246.field_10382.method_9564()), (float)Optifine.getRenderType(class_2246.field_10382.method_9564()), (float)-1.0f, (float)-1.0f);
            }
        }
        if (!shadowPass) {
            RenderSystem.activeTexture((int)(33984 + this.depthActiveTexture));
            GL32C.glBindTexture((int)3553, (int)depth.getID());
        }
        RenderSystem.activeTexture((int)33984);
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void setupLiquidsRendering(PhysicsWorld physics, class_638 level, class_5944 shader, int waterTexture) {
        FloatBuffer matrixBuffer;
        MemoryStack stack;
        if (level.method_28103().method_29993()) {
            RenderSystem.shaderLightDirections[0] = MainRenderer.NETHER_DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.NETHER_DIFFUSE_LIGHT_1;
        } else {
            RenderSystem.shaderLightDirections[0] = MainRenderer.DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.DIFFUSE_LIGHT_1;
        }
        RenderSystem.setupShaderLights((class_5944)shader);
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            if (shader.field_29475 != null) {
                shader.field_29475.method_1300();
            }
            if (shader.field_29476 != null) {
                shader.field_29476.method_1300();
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setColorModulator(RenderSystem.getShaderColor());
        } else if (shader.field_29474 != null) {
            shader.field_29474.method_1253(RenderSystem.getShaderColor());
            shader.field_29474.method_1300();
        }
        int shaderId = GL32C.glGetInteger((int)35725);
        int depthLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_depth");
        int invProjLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_invProjectionMatrix");
        int invViewLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_invViewMatrix");
        if (depthLocation != -1) {
            GL32C.glUniform1i((int)depthLocation, (int)this.depthActiveTexture);
        }
        if (invProjLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getProjectionMatrix().invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invProjLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (invViewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invViewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        RenderSystem.setShaderTexture((int)0, (int)waterTexture);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)waterTexture);
    }

    private VAO createLiquidVAO(Mesh mesh) {
        int size = mesh.indices.size();
        net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
        this.mainRenderer.checkArrays(size);
        for (int i = 0; i < size; ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f p = mesh.positions.get(index);
            Vector3f normal = mesh.normals.get(index);
            int cp = i * 3;
            this.mainRenderer.mpos[cp] = p.x;
            this.mainRenderer.mpos[cp + 1] = p.y;
            this.mainRenderer.mpos[cp + 2] = p.z;
            this.mainRenderer.mnormals[i] = Pack.normal(normal.x, normal.y, normal.z);
        }
        openglMesh.set(this.mainRenderer.mpos, Data.POSITION);
        openglMesh.set(this.mainRenderer.mnormals, Data.NORMAL);
        openglMesh.set(liquidpos, Data.LIQUID_POS);
        openglMesh.set(liquidposnew, Data.LIQUID_POS_NEW);
        openglMesh.setSize(Data.POSITION, size * 3);
        openglMesh.setSize(Data.NORMAL, size);
        openglMesh.setSize(Data.INDEX, size);
        return openglMesh.constructVAO(Usage.DYNAMIC);
    }

    private void checkLiquidArrays(int neededSize) {
        int size;
        boolean changed = false;
        for (size = liquidpos.length; neededSize > size; size *= 2) {
            changed = true;
        }
        if (changed) {
            liquidpos = new float[size];
            liquidposnew = new float[size];
        }
    }

    public void updateLiquidInstances(PhysicsWorld physics, class_243 cameraPos) {
        int size = 0;
        int count = 0;
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 + offset.x, cameraPos.field_1351 + offset.y, cameraPos.field_1350 + offset.z);
        if (ConfigClient.cudaLiquids()) {
            LiquidCuda liquid;
            int i;
            for (i = 0; i < physics.getLiquids().size(); ++i) {
                liquid = (LiquidCuda)physics.getLiquids().get(i);
                size += liquid.cudaPositions.length;
            }
            this.checkLiquidArrays(size * 4);
            for (i = 0; i < physics.getLiquids().size(); ++i) {
                liquid = (LiquidCuda)physics.getLiquids().get(i);
                float[] positions = liquid.cudaPositions;
                float[] oldPositions = liquid.cudaOldPositions;
                for (int j = 0; j < liquid.cudaParticleSize; ++j) {
                    this.prepareLiquidCudaInstances(physics, positions, oldPositions, j, this.offsetCamera, count++);
                }
            }
            this.liquidCount = count;
        } else {
            Liquid liquid;
            int i;
            for (i = 0; i < physics.getLiquids().size(); ++i) {
                liquid = physics.getLiquids().get(i);
                size += liquid.particles.size();
            }
            this.checkLiquidArrays(size * 4);
            for (i = 0; i < physics.getLiquids().size(); ++i) {
                liquid = physics.getLiquids().get(i);
                for (IRigidBody body : liquid.particles) {
                    this.prepareLiquidInstances(physics, body, this.offsetCamera, count++);
                }
            }
            this.liquidCount = count;
        }
        if (count == 0) {
            return;
        }
        liquidVAO.bind();
        liquidVAO.updateAttribute(Data.LIQUID_POS, liquidpos, count * 4);
        liquidVAO.updateAttribute(Data.LIQUID_POS_NEW, liquidposnew, count * 4);
    }

    private boolean prepareLiquidInstances(PhysicsWorld physics, IRigidBody body, Vector3d cameraPos, int offset) {
        int mulOffset = offset * 4;
        PhysicsEntity particle = body.getEntity();
        Matrix4d transformation = particle.getTransformation();
        Matrix4d transformationOld = particle.getOldTransformation();
        float scale = particle.getDespawnScale(physics.getWorld());
        LiquidDeferredRenderer.liquidpos[mulOffset] = (float)transformationOld.m30();
        LiquidDeferredRenderer.liquidpos[mulOffset + 1] = (float)transformationOld.m31();
        LiquidDeferredRenderer.liquidpos[mulOffset + 2] = (float)transformationOld.m32();
        LiquidDeferredRenderer.liquidpos[mulOffset + 3] = 1.0f;
        LiquidDeferredRenderer.liquidposnew[mulOffset] = (float)transformation.m30();
        LiquidDeferredRenderer.liquidposnew[mulOffset + 1] = (float)transformation.m31();
        LiquidDeferredRenderer.liquidposnew[mulOffset + 2] = (float)transformation.m32();
        LiquidDeferredRenderer.liquidposnew[mulOffset + 3] = scale * 0.25f;
        return true;
    }

    private boolean prepareLiquidCudaInstances(PhysicsWorld physics, float[] positions, float[] oldPositions, int index, Vector3d cameraPos, int offset) {
        int mulOffset = offset * 4;
        int mulIndex = index * 3;
        LiquidDeferredRenderer.liquidpos[mulOffset] = oldPositions[mulIndex];
        LiquidDeferredRenderer.liquidpos[mulOffset + 1] = oldPositions[mulIndex + 1];
        LiquidDeferredRenderer.liquidpos[mulOffset + 2] = oldPositions[mulIndex + 2];
        LiquidDeferredRenderer.liquidpos[mulOffset + 3] = 1.0f;
        LiquidDeferredRenderer.liquidposnew[mulOffset] = positions[mulIndex];
        LiquidDeferredRenderer.liquidposnew[mulOffset + 1] = positions[mulIndex + 1];
        LiquidDeferredRenderer.liquidposnew[mulOffset + 2] = positions[mulIndex + 2];
        LiquidDeferredRenderer.liquidposnew[mulOffset + 3] = physics.fluidParticleSize;
        return true;
    }

    public static void destroy() {
        if (depthFBO != null) {
            depthFBO.destroy(true);
        }
        if (liquidShader != null) {
            liquidShader.destroy();
        }
        if (liquidVAO != null) {
            liquidVAO.destroy();
        }
        if (liquidDepthCopy != null) {
            liquidDepthCopy.destroy();
        }
        if (emptyVAO != null) {
            emptyVAO.destroy();
        }
        if (emptyTextureShader != null) {
            emptyTextureShader.destroy();
        }
        if (blurEffect != null) {
            blurEffect.destroy();
        }
    }

    static {
        liquidpos = new float[400];
        liquidposnew = new float[400];
        viewport = new int[4];
    }
}

