/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_898;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class LeashConstraint
implements VerletConstraint {
    private Vector3d leashOriginAsync = new Vector3d();
    private Vector3d leashTargetAsync = new Vector3d();
    private Vector3d leashOrigin = new Vector3d();
    private Vector3d leashTarget = new Vector3d();
    private class_1297 mob;
    private class_1297 entity;
    private class_898 entityRenderDispatcher;

    public LeashConstraint(VerletSimulation simulation, class_1297 mob, class_1297 entity, class_898 entityRenderDispatcher, float tickDelta) {
        int i;
        this.mob = mob;
        this.entity = entity;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.calculateLeashOriginAndTarget(tickDelta, this.leashOrigin, this.leashTarget);
        int pointCount = 20;
        double totalLength = ConfigClient.leashLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.leashOrigin.x, (double)this.leashTarget.x, (double)perc), Math.lerp((double)this.leashOrigin.y, (double)this.leashTarget.y, (double)perc), Math.lerp((double)this.leashOrigin.z, (double)this.leashTarget.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            float colMod = i % 2 == 0 ? 0.7f : 1.0f;
            float r = 0.5f * colMod;
            float g = 0.4f * colMod;
            float b = 0.3f * colMod;
            point.rgba.set(r, g, b, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    private void calculateLeashOriginAndTarget(float tickDelta, Vector3d leashOrigin, Vector3d leashTarget) {
        class_243 ropePosition = this.entity.method_30951(tickDelta);
        double bodyRot = (double)(this.entity.method_60951(tickDelta) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        class_243 leashOffset = this.mob.method_45321(tickDelta);
        double leashOffset1 = java.lang.Math.cos(bodyRot) * leashOffset.field_1350 + java.lang.Math.sin(bodyRot) * leashOffset.field_1352;
        double leashOffset2 = java.lang.Math.sin(bodyRot) * leashOffset.field_1350 - java.lang.Math.cos(bodyRot) * leashOffset.field_1352;
        double mobX = class_3532.method_16436((double)tickDelta, (double)this.mob.field_6014, (double)this.mob.method_23317()) + leashOffset1;
        double mobY = class_3532.method_16436((double)tickDelta, (double)this.mob.field_6036, (double)this.mob.method_23318()) + leashOffset.field_1351;
        double mobZ = class_3532.method_16436((double)tickDelta, (double)this.mob.field_5969, (double)this.mob.method_23321()) + leashOffset2;
        float ropeDirX = (float)(ropePosition.field_1352 - mobX);
        float ropeDirY = (float)(ropePosition.field_1351 - mobY);
        float ropeDirZ = (float)(ropePosition.field_1350 - mobZ);
        float hangingRate = class_3532.method_48119((float)(ropeDirX * ropeDirX + ropeDirZ * ropeDirZ)) * 0.025f / 2.0f;
        float hangingRateZ = ropeDirZ * hangingRate;
        float hangingRateX = ropeDirX * hangingRate;
        class_2338 mob1Pos = class_2338.method_49638((class_2374)this.mob.method_5836(tickDelta));
        class_2338 mob2Pos = class_2338.method_49638((class_2374)this.entity.method_5836(tickDelta));
        int mob1Brightness = this.entityRenderDispatcher.method_3953(this.mob).method_24087(this.mob, mob1Pos);
        int mob2Brightness = this.entityRenderDispatcher.method_3953(this.entity).method_24087(this.entity, mob2Pos);
        int mob1BrightnessSky = this.mob.method_37908().method_8314(class_1944.field_9284, mob1Pos);
        int mob2BrightnessSky = this.mob.method_37908().method_8314(class_1944.field_9284, mob2Pos);
        double ropeOffset = 0.0;
        leashOrigin.set(ropePosition.field_1352, ropePosition.field_1351 + ropeOffset, ropePosition.field_1350);
        leashTarget.set(mobX, mobY, mobZ);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.calculateLeashOriginAndTarget(1.0f, this.leashOriginAsync, this.leashTargetAsync);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint originPoint = simulation.getPoints().get(0);
        VerletPoint targetPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        originPoint.position.set((Vector3dc)this.leashOriginAsync).sub((Vector3dc)simulation.getOffset());
        targetPoint.position.set((Vector3dc)this.leashTargetAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        this.calculateLeashOriginAndTarget((float)delta, this.leashOrigin, this.leashTarget);
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.leashOrigin).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.leashTarget).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

