/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.minecraft.ShipRotation;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityOcean;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;

@Pseudo
@Mixin(value={ShipObjectClient.class})
public class MixinShipObjectClient
implements EntityOcean,
ShipRotation {
    @Unique
    private double physicsOffset;
    @Unique
    private double physicsOldOffset;
    @Unique
    private double physicsRoll;
    @Unique
    private double physicsOldRoll;
    @Unique
    private double physicsPitch;
    @Unique
    private double physicsOldPitch;
    @Unique
    private double velocityY;
    @Unique
    private double velocityRoll;
    @Unique
    private double velocityPitch;
    @Unique
    private boolean wasInAir;
    @Unique
    private double rippleTime;
    @Unique
    private boolean wasEyeUnderwater;
    @Unique
    private Quaterniondc originalShipRotation;
    @Shadow(remap=false)
    private ShipTransform renderTransform;

    @Inject(at={@At(value="TAIL")}, method={"tickUpdateShipTransform"}, remap=false)
    public final void physicsmod$calculateWaveTransforms(CallbackInfo info) {
        ShipObjectClient ship = (ShipObjectClient)this;
        class_638 level = class_310.method_1551().field_1687;
    }

    @Inject(at={@At(value="HEAD")}, method={"getRenderTransform"}, remap=false)
    public void physicsmod$getRenderTransform(CallbackInfoReturnable<ShipTransform> info) {
    }

    @Inject(at={@At(value="TAIL")}, method={"updateRenderShipTransform"}, remap=false)
    public final void physicsmod$applyOceanTransformation(double partialTicks, CallbackInfo info) {
        double pitch = this.getPhysicsPitch((float)partialTicks);
        double roll = this.getPhysicsRoll((float)partialTicks);
        float actualYRot = (float)this.renderTransform.getShipToWorldRotation().get((Matrix4d)new Matrix4d()).getEulerAnglesXYZ((Vector3d)new Vector3d()).y;
        double forwardZ = Math.cos(actualYRot);
        double forwardX = Math.sin(actualYRot);
        double leftX = forwardZ;
        double leftZ = -forwardX;
        Matrix4f transformation = new Matrix4f();
        transformation.rotate((Quaternionfc)class_7833.method_46356((Vector3f)new Vector3f((float)forwardX, 0.0f, (float)forwardZ)).rotationDegrees((float)(-Math.toDegrees(roll))));
        transformation.rotate((Quaternionfc)class_7833.method_46356((Vector3f)new Vector3f((float)leftX, 0.0f, (float)leftZ)).rotationDegrees((float)Math.toDegrees(pitch)));
        this.originalShipRotation = this.renderTransform.getShipToWorldRotation();
        this.renderTransform = ShipTransformImpl.Companion.create((Vector3dc)new Vector3d(this.renderTransform.getPositionInWorld()).add(0.0, this.getPhysicsYOffset((float)partialTicks), 0.0), this.renderTransform.getPositionInShip(), (Quaterniondc)this.renderTransform.getShipToWorldRotation().mul((Quaterniondc)transformation.getUnnormalizedRotation(new Quaterniond()), new Quaterniond()), this.renderTransform.getShipToWorldScaling());
    }

    @Override
    public Quaterniondc getOriginalRotation() {
        if (this.originalShipRotation == null) {
            this.originalShipRotation = new Quaterniond();
        }
        return this.originalShipRotation;
    }

    @Override
    public double getPhysicsYOffset(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldYOffset(), (double)this.getPhysicsYOffset());
    }

    @Override
    public double getPhysicsPitch(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldPitch(), (double)this.getPhysicsPitch());
    }

    @Override
    public double getPhysicsRoll(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldRoll(), (double)this.getPhysicsRoll());
    }

    @Override
    public double getPhysicsYOffset() {
        return this.physicsOffset;
    }

    @Override
    public double getPhysicsOldYOffset() {
        return this.physicsOldOffset;
    }

    @Override
    public double getPhysicsPitch() {
        return this.physicsPitch;
    }

    @Override
    public double getPhysicsOldPitch() {
        return this.physicsOldPitch;
    }

    @Override
    public double getPhysicsRoll() {
        return this.physicsRoll;
    }

    @Override
    public double getPhysicsOldRoll() {
        return this.physicsOldRoll;
    }

    @Override
    public boolean isInPhysicsAir() {
        return this.wasInAir;
    }
}

