/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.compat.ValkyrienSkies;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public class MixinEntity
implements EntityOcean {
    @Unique
    private double physicsOffset;
    @Unique
    private double physicsOldOffset;
    @Unique
    private double physicsRoll;
    @Unique
    private double physicsOldRoll;
    @Unique
    private double physicsPitch;
    @Unique
    private double physicsOldPitch;
    @Unique
    private double velocityY;
    @Unique
    private double velocityRoll;
    @Unique
    private double velocityPitch;
    @Unique
    private boolean wasInAir;
    @Unique
    private double rippleTime;
    @Unique
    private boolean wasEyeUnderwater;

    @Inject(at={@At(value="HEAD")}, method={"doWaterSplashEffect"})
    private void physicsmod$doOceanRippleEffect(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
    }

    @Unique
    private void spawnSplashRipple(class_1297 entity) {
        class_243 deltaMovement = entity.method_18798();
        double vy = java.lang.Math.abs(deltaMovement.field_1351);
        if (vy < 0.1) {
            return;
        }
        double speed = Math.remapClamp(vy, 0.1, 2.0, 0.0425, 0.0625);
        int amount = (int)Math.remapClamp(vy, 0.1, 2.0, 120.0, 240.0);
        int lifetime = (int)Math.remapClamp(vy, 0.1, 2.0, 70.0, 80.0);
        float scale = (float)Math.remapClamp(vy, 0.1, 2.0, 0.2, 0.65);
        OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
        oceanWorld.spawnRipple(amount, lifetime, scale, entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), speed);
    }

    @Unique
    private void spawnSplashParticles(class_1297 entity) {
        class_243 deltaMovement = entity.method_18798();
        double vy = java.lang.Math.abs(deltaMovement.field_1351);
        if (vy < 0.25) {
            return;
        }
        int splashamount = (int)Math.remapClamp(vy, 0.1, 2.0, 10.0, 75.0);
        double intensity = Math.remapClamp(vy, 0.1, 2.0, 0.075, 0.5);
        float volume = (float)intensity * ConfigClient.oceanSplashVolume;
        float pitch = Math.random() * 0.4f + 0.7f;
        class_1937 level = entity.method_37908();
        level.method_8486(entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), WeatherEffects.SPLASH_SOUND_EVENT, class_3419.field_15256, volume, pitch, true);
        if (ConfigClient.oceanParticles) {
            OceanWorld.createWaterSplash(level, entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), 0.0, 0.0, 0.0, 0.25, intensity, splashamount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$spawnMovementRippleEffect(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
    }

    @Unique
    private boolean isCausingSplash(class_1297 entity) {
        boolean isEyeUnderwater = entity.method_5777(class_3486.field_15517);
        boolean result = !isEyeUnderwater && this.wasEyeUnderwater;
        this.wasEyeUnderwater = isEyeUnderwater;
        return result;
    }

    @Unique
    private boolean isCausingRipples(class_1297 entity) {
        boolean isOnSurface = true;
        if (!ConfigClient.oceanStickyEntities && entity instanceof class_1690) {
            isOnSurface = !((EntityOcean)entity).isInPhysicsAir();
        }
        return isOnSurface && !entity.method_7325() && entity.method_5799() && (entity.method_37908().method_8320(entity.method_24515().method_10084()).method_26215() || entity instanceof class_742 && entity.method_37908().method_8320(entity.method_24515().method_10084().method_10084()).method_26215());
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$updateOceanTransformations(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
    }

    @Inject(at={@At(value="HEAD")}, method={"pick"}, cancellable=true)
    private void physicsmod$modifyBlockPickingForOceanTransformations(double range, float renderPercent, boolean bl, CallbackInfoReturnable<class_239> info) {
        class_1297 entity = (class_1297)this;
    }

    @Override
    public double getPhysicsYOffset(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldYOffset(), (double)this.getPhysicsYOffset());
    }

    @Override
    public double getPhysicsPitch(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldPitch(), (double)this.getPhysicsPitch());
    }

    @Override
    public double getPhysicsRoll(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldRoll(), (double)this.getPhysicsRoll());
    }

    @Override
    public double getPhysicsYOffset() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsYOffset();
        }
        return this.physicsOffset;
    }

    @Override
    public double getPhysicsOldYOffset() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldYOffset();
        }
        return this.physicsOldOffset;
    }

    @Override
    public double getPhysicsPitch() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsPitch();
        }
        return this.physicsPitch;
    }

    @Override
    public double getPhysicsOldPitch() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldPitch();
        }
        return this.physicsOldPitch;
    }

    @Override
    public double getPhysicsRoll() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsRoll();
        }
        return this.physicsRoll;
    }

    @Override
    public double getPhysicsOldRoll() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldRoll();
        }
        return this.physicsOldRoll;
    }

    @Override
    public boolean isInPhysicsAir() {
        return this.wasInAir;
    }
}

