/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.physxjni;

import de.fabmax.physxjni.NativeLib;
import de.fabmax.physxjni.Platform;
import java.util.concurrent.atomic.AtomicBoolean;
import physx.PlatformChecks;

public class Loader {
    private static final String version = "2.3.2";
    private static final AtomicBoolean isLoaded = new AtomicBoolean(false);

    public static void load() {
        if (!isLoaded.getAndSet(true)) {
            Platform platform = Platform.getPlatform();
            try {
                switch (platform) {
                    case LINUX: {
                        PlatformChecks.setPlatformBit(2);
                        break;
                    }
                    case WINDOWS: {
                        PlatformChecks.setPlatformBit(1);
                        break;
                    }
                    case MACOS: 
                    case MACOS_ARM64: {
                        PlatformChecks.setPlatformBit(4);
                    }
                }
                NativeLib lib = platform.getLib();
                if (!version.equals(lib.getVersion())) {
                    throw new IllegalStateException("Native lib version " + lib.getVersion() + " differs from main version 2.3.2");
                }
                lib.load();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed loading native PhysX libraries for platform " + platform, t);
            }
        }
    }
}

