/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.PositionedRectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public final class ScissorStack {
    private static final class_4587 EMPTY_STACK = new class_4587();
    private static final Deque<PositionedRectangle> STACK = new ArrayDeque<PositionedRectangle>();

    private ScissorStack() {
    }

    public static void pushDirect(int x, int y, int width, int height) {
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        ScissorStack.push((int)((double)x / scale), (int)((double)window.method_4502() - (double)y / scale - (double)height / scale), (int)((double)width / scale), (int)((double)height / scale), (class_4587)null);
    }

    public static void push(int x, int y, int width, int height, class_332 context) {
        context.method_51452();
        ScissorStack.push(x, y, width, height, context.method_51448());
    }

    public static void push(int x, int y, int width, int height, @Nullable class_4587 matrices) {
        PositionedRectangle newFrame = ScissorStack.withGlTransform(x, y, width, height, matrices);
        if (STACK.isEmpty()) {
            STACK.push(newFrame);
        } else {
            PositionedRectangle top = STACK.peek();
            STACK.push(top.intersection(newFrame));
        }
        ScissorStack.applyState();
    }

    public static void pop() {
        if (STACK.isEmpty()) {
            throw new IllegalStateException("Cannot pop frame from empty scissor stack");
        }
        STACK.pop();
        ScissorStack.applyState();
    }

    private static void applyState() {
        if (STACK.isEmpty()) {
            class_1041 window = class_310.method_1551().method_22683();
            GL11.glScissor((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
            return;
        }
        if (!GL11.glIsEnabled((int)3089)) {
            return;
        }
        PositionedRectangle newFrame = STACK.peek();
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        GL11.glScissor((int)Math.max(0, (int)((double)newFrame.x() * scale)), (int)Math.max((int)((double)window.method_4506() - (double)newFrame.y() * scale - (double)newFrame.height() * scale), 0), (int)Math.min(class_3532.method_15340((int)((int)((double)newFrame.width() * scale)), (int)0, (int)window.method_4489()), window.method_4489()), (int)Math.min(class_3532.method_15340((int)((int)((double)newFrame.height() * scale)), (int)0, (int)window.method_4506()), window.method_4506()));
    }

    public static void drawUnclipped(Runnable action) {
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        if (scissorEnabled) {
            GlStateManager._disableScissorTest();
        }
        action.run();
        if (scissorEnabled) {
            GlStateManager._enableScissorTest();
        }
    }

    public static void popFramesAndDraw(int maxPopFrames, Runnable action) {
        ArrayList<PositionedRectangle> previousFrames = new ArrayList<PositionedRectangle>();
        while (maxPopFrames > 1 && STACK.size() > 1) {
            previousFrames.add(0, STACK.pop());
            --maxPopFrames;
        }
        ScissorStack.applyState();
        action.run();
        previousFrames.forEach(STACK::push);
        ScissorStack.applyState();
    }

    public static boolean isVisible(int x, int y, @Nullable class_4587 matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        return top.intersects(ScissorStack.withGlTransform(x, y, 0, 0, matrices));
    }

    public static boolean isVisible(Component component, @Nullable class_4587 matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        Insets margins = (Insets)component.margins().get();
        return top.intersects(ScissorStack.withGlTransform(component.x() - margins.left(), component.y() - margins.top(), component.width() + margins.right(), component.height() + margins.bottom(), matrices));
    }

    private static PositionedRectangle withGlTransform(int x, int y, int width, int height, @Nullable class_4587 matrices) {
        if (matrices == null) {
            matrices = EMPTY_STACK;
        }
        matrices.method_22903();
        matrices.method_34425(RenderSystem.getModelViewMatrix());
        Vector4f root = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f);
        root.mul((Matrix4fc)matrices.method_23760().method_23761());
        end.mul((Matrix4fc)matrices.method_23760().method_23761());
        x = (int)root.x;
        y = (int)root.y;
        width = (int)Math.ceil(end.x - root.x);
        height = (int)Math.ceil(end.y - root.y);
        matrices.method_22909();
        return PositionedRectangle.of(x, y, width, height);
    }
}

