/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.util;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import java.time.Duration;
import java.time.Instant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DynamicLightSectionDebugRenderer
extends DynamicLightDebugRenderer {
    private static final Duration REFRESH_INTERVAL = Duration.ofMillis(250L);
    private static final int RADIUS = 10;
    private static final int COLOR = 1073715456;
    private static final int ACTIVE_COLOR = 0x3FFFFF00;
    private static final int ACTIVE_NEIGHBOR_COLOR = 436190976;
    private final DynamicLightingEngine lightingEngine;
    private Instant lastUpdateTime = Instant.now();
    @Nullable
    private SectionData data;

    public DynamicLightSectionDebugRenderer() {
        super(LambDynLights.get());
        this.lightingEngine = LambDynLights.get().engine;
    }

    public void method_23109(class_4587 matrices, class_4597 bufferSource, double x, double y, double z) {
        int cellDisplayRadius = this.config.getDebugCellDisplayRadius();
        if (!((Boolean)this.config.getDebugActiveDynamicLightingCells().get()).booleanValue() && cellDisplayRadius == 0) {
            return;
        }
        Instant instant = Instant.now();
        if (this.data == null || Duration.between(this.lastUpdateTime, instant).compareTo(REFRESH_INTERVAL) > 0) {
            this.lastUpdateTime = instant;
            this.data = new SectionData(this.lightingEngine, 10, this.client.field_1724.method_24515());
        }
        int playerCellX = DynamicLightingEngine.positionToCell(this.client.field_1724.method_24515().method_10263());
        int playerCellY = DynamicLightingEngine.positionToCell(this.client.field_1724.method_24515().method_10264());
        int playerCellZ = DynamicLightingEngine.positionToCell(this.client.field_1724.method_24515().method_10260());
        int playerHash = DynamicLightingEngine.hashCell(playerCellX, playerCellY, playerCellZ);
        if (cellDisplayRadius > 0) {
            for (int offsetX = 0; offsetX < cellDisplayRadius * 2 + 1; ++offsetX) {
                for (int offsetY = 0; offsetY < cellDisplayRadius * 2 + 1; ++offsetY) {
                    for (int offsetZ = 0; offsetZ < cellDisplayRadius * 2 + 1; ++offsetZ) {
                        int cellX = playerCellX + offsetX - cellDisplayRadius;
                        int cellY = playerCellY + offsetY - cellDisplayRadius;
                        int cellZ = playerCellZ + offsetZ - cellDisplayRadius;
                        int currentHash = DynamicLightingEngine.hashCell(cellX, cellY, cellZ);
                        class_863.method_23106((class_4587)matrices, (class_4597)bufferSource, (String)"HASH(%d, %d, %d) = %d".formatted(cellX, cellY, cellZ, currentHash), (double)((double)(cellX * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (double)((double)(cellY * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (double)((double)(cellZ * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (int)(playerHash == currentHash ? -65536 : -16711936), (float)0.08f);
                    }
                }
            }
        }
        DynamicLightSectionDebugRenderer.renderEdges(matrices, this.data.matchShape, this.data.origin, bufferSource, x, y, z, DynamicLightingEngine.CELL_SIZE, 1073715456);
        if (((Boolean)this.config.getDebugActiveDynamicLightingCells().get()).booleanValue()) {
            DynamicLightSectionDebugRenderer.renderEdges(matrices, this.data.activeShape, this.data.origin, bufferSource, x, y, z, DynamicLightingEngine.CELL_SIZE, 0x3FFFFF00);
            DynamicLightSectionDebugRenderer.renderEdges(matrices, this.data.activeNeighborShape, this.data.origin, bufferSource, x, y, z, DynamicLightingEngine.CELL_SIZE, 436190976);
            this.data.activeShape.method_1053((startCellX, startCellY, startCellZ, endCellX, endCellY, endCellZ) -> {
                for (int currentCellX = startCellX; currentCellX < endCellX; ++currentCellX) {
                    for (int currentCellY = startCellY; currentCellY < endCellY; ++currentCellY) {
                        for (int currentCellZ = startCellZ; currentCellZ < endCellZ; ++currentCellZ) {
                            int cellX = currentCellX + this.data.origin.method_10263();
                            int cellY = currentCellY + this.data.origin.method_10264();
                            int cellZ = currentCellZ + this.data.origin.method_10260();
                            class_863.method_23106((class_4587)matrices, (class_4597)bufferSource, (String)"%d".formatted(this.lightingEngine.getEntryCountAt(cellX, cellY, cellZ)), (double)((double)(cellX * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (double)((double)(cellY * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (double)((double)(cellZ * DynamicLightingEngine.CELL_SIZE) + (double)DynamicLightingEngine.CELL_SIZE / 2.0), (int)-256, (float)0.2f);
                        }
                    }
                }
            }, true);
        }
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_51456());
        DynamicLightSectionDebugRenderer.renderFaces(matrices, this.data.matchShape, this.data.origin, vertexConsumer, x, y, z, DynamicLightingEngine.CELL_SIZE, 1073715456);
        if (((Boolean)this.config.getDebugActiveDynamicLightingCells().get()).booleanValue()) {
            DynamicLightSectionDebugRenderer.renderFaces(matrices, this.data.activeShape, this.data.origin, vertexConsumer, x, y, z, DynamicLightingEngine.CELL_SIZE, 0x3FFFFF00);
            DynamicLightSectionDebugRenderer.renderFaces(matrices, this.data.activeNeighborShape, this.data.origin, vertexConsumer, x, y, z, DynamicLightingEngine.CELL_SIZE, 436190976);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static final class SectionData {
        final class_251 matchShape;
        final class_251 activeShape;
        final class_251 activeNeighborShape;
        final int playerCellX;
        final int playerCellY;
        final int playerCellZ;
        final int playerHash;
        final class_2382 origin;

        SectionData(DynamicLightingEngine engine, int radius, class_2338 playerPos) {
            int perimeter = radius * 2 + 1;
            this.matchShape = new class_244(perimeter, perimeter, perimeter);
            this.activeShape = new class_244(perimeter, perimeter, perimeter);
            this.activeNeighborShape = new class_244(perimeter, perimeter, perimeter);
            this.playerCellX = DynamicLightingEngine.positionToCell(playerPos.method_10263());
            this.playerCellY = DynamicLightingEngine.positionToCell(playerPos.method_10264());
            this.playerCellZ = DynamicLightingEngine.positionToCell(playerPos.method_10260());
            this.playerHash = DynamicLightingEngine.hashCell(this.playerCellX, this.playerCellY, this.playerCellZ);
            for (int offsetX = 0; offsetX < perimeter; ++offsetX) {
                for (int offsetY = 0; offsetY < perimeter; ++offsetY) {
                    for (int offsetZ = 0; offsetZ < perimeter; ++offsetZ) {
                        int currentCellX = this.playerCellX - radius + offsetX;
                        int currentCellY = this.playerCellY - radius + offsetY;
                        int currentCellZ = this.playerCellZ - radius + offsetZ;
                        if (DynamicLightingEngine.hashCell(currentCellX, currentCellY, currentCellZ) == this.playerHash && (offsetX != radius || offsetY != radius || offsetZ != radius)) {
                            this.matchShape.method_1049(offsetX, offsetY, offsetZ);
                        }
                        if (!engine.hasEntriesAt(currentCellX, currentCellY, currentCellZ)) continue;
                        this.activeShape.method_1049(offsetX, offsetY, offsetZ);
                        for (int neighorX = -1; neighorX <= 1; ++neighorX) {
                            for (int neighorY = -1; neighorY <= 1; ++neighorY) {
                                for (int neighorZ = -1; neighorZ <= 1; ++neighorZ) {
                                    if (offsetX + neighorX < 0 || offsetY + neighorY < 0 || offsetZ + neighorZ < 0 || offsetX + neighorX >= perimeter || offsetY + neighorY >= perimeter || offsetZ + neighorZ >= perimeter) continue;
                                    this.activeNeighborShape.method_1049(offsetX + neighorX, offsetY + neighorY, offsetZ + neighorZ);
                                }
                            }
                        }
                    }
                }
            }
            this.origin = new class_2382(this.playerCellX - radius, this.playerCellY - radius, this.playerCellZ - radius);
        }
    }
}

