/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import journeymap.api.services.Services;
import journeymap.common.nbt.model.PlayerDTO;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class PlayerData
extends class_18 {
    private static final Codec<PlayerDTO> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(PlayerDTO::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(PlayerDTO::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(PlayerDTO::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(PlayerDTO::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(PlayerDTO::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(PlayerDTO::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(PlayerDTO::isChunkInaccessible)).apply((Applicative)instance, PlayerDTO::new));
    private static final String DAT_FILE = "JMPlayerSettings";
    private class_2487 data = new class_2487();
    Map<String, PlayerDTO> playerMap = new HashMap<String, PlayerDTO>();

    public PlayerData() {
        Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179).method_17983().method_123(DAT_FILE, (class_18)this);
        this.method_80();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        this.playerMap.forEach((uuid, player) -> {
            DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, player);
            if (result.result().isPresent()) {
                this.data.method_10566(uuid, (class_2520)result.result().get());
            }
        });
        compound.method_10566(DAT_FILE, (class_2520)this.data);
        return compound;
    }

    private static PlayerData get() {
        class_3218 level = Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179);
        return (PlayerData)level.method_17983().method_17924(PlayerData.dataFactory(), DAT_FILE);
    }

    private static PlayerData load(class_2487 nbt, class_7225.class_7874 provider) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.method_10562(DAT_FILE);
        return playerData;
    }

    public static class_18.class_8645<PlayerData> dataFactory() {
        return new class_18.class_8645(PlayerData::load, PlayerData::load, class_4284.field_19216);
    }

    private static PlayerData load() {
        return new PlayerData();
    }

    public PlayerDTO getPlayer(class_3222 serverPlayer) {
        String uuid = serverPlayer.method_5845();
        PlayerDTO player = this.playerMap.get(uuid);
        if (player == null) {
            class_2487 playterTag;
            DataResult result;
            if (this.data.method_10545(uuid) && (result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)(playterTag = this.data.method_10562(uuid)))).result().isPresent()) {
                PlayerDTO playerData = (PlayerDTO)result.result().get();
                this.playerMap.put(uuid, playerData);
                return playerData;
            }
            player = new PlayerDTO(uuid);
            DataResult result2 = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)player);
            this.data.method_10566(uuid, (class_2520)result2.result().get());
            this.playerMap.put(uuid, player);
        }
        return player;
    }
}

