/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import net.minecraft.class_10156;
import net.minecraft.class_10366;
import net.minecraft.class_2960;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30C;

public class RenderWrapper {
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_REPEAT = 10497;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_ZERO = 0;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_GEQUAL = 518;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_VIEWPORT = 2978;
    public static final int UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_BGRA = 32993;
    public static final int GL_RGBA = 6408;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_TEXTURE_LOD_BIAS = 34049;
    public static final boolean errorCheck = JourneymapClient.getInstance().getCoreProperties().glErrorChecking.get();

    public static void setColor4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderWrapper.checkGLError("setColor4f");
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        RenderSystem.clearColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderWrapper.checkGLError("clearColor");
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
        RenderWrapper.checkGLError("enableBlend");
    }

    public static void disableBlend() {
        RenderSystem.disableBlend();
        RenderWrapper.checkGLError("disableBlend");
    }

    public static void defaultBlendFunc() {
        RenderSystem.defaultBlendFunc();
        RenderWrapper.checkGLError("defaultBlendFunc");
    }

    public static void enableDepthTest() {
        RenderSystem.enableDepthTest();
        RenderWrapper.checkGLError("enableDepthTest");
    }

    public static void disableDepthTest() {
        RenderSystem.disableDepthTest();
        RenderWrapper.checkGLError("disableDepthTest");
    }

    public static Matrix4f getProjectionMatrix() {
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        RenderWrapper.checkGLError("getProjectionMatrix");
        return projectionMatrix;
    }

    public static void enableCull() {
        RenderSystem.enableCull();
        RenderWrapper.checkGLError("enableCull");
    }

    public static void disableCull() {
        RenderSystem.disableCull();
        RenderWrapper.checkGLError("disableCull");
    }

    public static int getError() {
        return GlStateManager._getError();
    }

    public static void depthMask(boolean flag) {
        RenderSystem.depthMask((boolean)flag);
        RenderWrapper.checkGLError("depthMask");
    }

    public static void getIntegerv(int pname, IntBuffer params) {
        GL11C.glGetIntegerv((int)pname, (IntBuffer)params);
        RenderWrapper.checkGLError("getIntegerv");
    }

    public static void texParameter(int target, int pname, int param) {
        RenderSystem.texParameter((int)target, (int)pname, (int)param);
        RenderWrapper.checkGLError("texParameter");
    }

    public static void blendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        RenderSystem.blendFuncSeparate((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        RenderWrapper.checkGLError("blendFuncSeparate");
    }

    public static void blendFunc(int sfactor, int dfactor) {
        RenderSystem.blendFunc((int)sfactor, (int)dfactor);
        RenderWrapper.checkGLError("blendFunc");
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        GlStateManager._glBindFramebuffer((int)target, (int)framebuffer);
        RenderWrapper.checkGLError("bindFramebuffer");
    }

    public static void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GlStateManager._glBlitFrameBuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
        RenderWrapper.checkGLError("blitFramebuffer");
    }

    public static void setShader(class_10156 shaderInstanceSupplier) {
        RenderSystem.setShader((class_10156)shaderInstanceSupplier);
        RenderWrapper.checkGLError("setShader");
    }

    public static void generateMipmap(int target) {
        GL30C.glGenerateMipmap((int)target);
        RenderWrapper.checkGLError("generateMipmap");
    }

    public static void setShaderTexture(int index, int id) {
        RenderSystem.setShaderTexture((int)index, (int)id);
        RenderWrapper.checkGLError("setShaderTexture");
    }

    public static void setShaderTexture(int index, class_2960 resourceLocation) {
        RenderSystem.setShaderTexture((int)index, (class_2960)resourceLocation);
        RenderWrapper.checkGLError("setShaderTexture");
    }

    public static void activeTexture(int texture) {
        RenderSystem.activeTexture((int)texture);
        RenderWrapper.checkGLError("activeTexture");
    }

    public static void bindTextureForSetup(int id) {
        RenderSystem.bindTextureForSetup((int)id);
        RenderWrapper.checkGLError("bindTextureForSetup");
    }

    public static void bindTexture(int id) {
        RenderSystem.bindTexture((int)id);
        RenderWrapper.checkGLError("bindTexture");
    }

    public static void clear(int mask) {
        RenderSystem.clear((int)mask);
        RenderWrapper.checkGLError("clear");
    }

    public static void depthFunc(int func) {
        RenderSystem.depthFunc((int)func);
        RenderWrapper.checkGLError("depthFunc");
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.colorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
        RenderWrapper.checkGLError("colorMask");
    }

    public static void setProjectionMatrix(Matrix4f matrix4f, class_10366 sorting) {
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_10366)sorting);
        RenderWrapper.checkGLError("setProjectionMatrix");
    }

    public static Matrix4fStack getModelViewStack() {
        Matrix4fStack stack = RenderSystem.getModelViewStack();
        RenderWrapper.checkGLError("getModelViewStack");
        return stack;
    }

    public static void lineWidth(float stroke) {
        RenderSystem.lineWidth((float)stroke);
        RenderWrapper.checkGLError("lineWidth");
    }

    public static void pixelStore(int pname, int param) {
        RenderSystem.pixelStore((int)pname, (int)param);
        RenderWrapper.checkGLError("pixelStore");
    }

    public static void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GlStateManager._texImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
        RenderWrapper.checkGLError("texImage2D");
    }

    public static void applyModelViewMatrix() {
        RenderWrapper.checkGLError("applyModelViewMatrix");
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GlStateManager._texSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
        RenderWrapper.checkGLError("texSubImage2D");
    }

    public static boolean checkGLError(String method) {
        if (errorCheck) {
            int err;
            boolean hasError = false;
            while ((err = RenderWrapper.getError()) != 0) {
                hasError = true;
                JMLogger.logOnce("GL Error in method: " + method + " ERROR: " + err);
            }
            return hasError;
        }
        return false;
    }
}

