/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.region;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageSet;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public enum RegionImageCache {
    INSTANCE;

    public final long firstFileFlushIntervalSecs = 5L;
    public final long flushFileIntervalSecs = 60L;
    public final long textureCacheAgeSecs = 30L;
    static final Logger logger;
    private volatile long lastFlush = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);

    public LoadingCache<RegionImageSet.Key, RegionImageSet> initRegionImageSetsCache(CacheBuilder<Object, Object> builder) {
        return builder.expireAfterAccess(30L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<RegionImageSet.Key, RegionImageSet>(this){

            @ParametersAreNonnullByDefault
            public void onRemoval(RemovalNotification<RegionImageSet.Key, RegionImageSet> notification) {
                RegionImageSet regionImageSet = (RegionImageSet)notification.getValue();
                if (regionImageSet != null) {
                    int count = regionImageSet.writeToDisk(false);
                    if (count > 0 && Journeymap.getLogger().isDebugEnabled()) {
                        Journeymap.getLogger().debug("Wrote to disk before removal from cache: " + String.valueOf(regionImageSet));
                    }
                    regionImageSet.clear();
                }
            }
        }).build((CacheLoader)new CacheLoader<RegionImageSet.Key, RegionImageSet>(this){

            @ParametersAreNonnullByDefault
            public RegionImageSet load(RegionImageSet.Key key) {
                return new RegionImageSet(key);
            }
        });
    }

    public RegionImageSet getRegionImageSet(ChunkMD chunkMd, MapType mapType) {
        if (chunkMd.hasChunk()) {
            class_310 mc = class_310.method_1551();
            class_2818 chunk = chunkMd.getChunk();
            RegionCoord rCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(mc), mapType, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
            return this.getRegionImageSet(rCoord);
        }
        return null;
    }

    public RegionImageSet getRegionImageSet(RegionCoord rCoord) {
        return (RegionImageSet)DataCache.INSTANCE.getRegionImageSets().getUnchecked((Object)RegionImageSet.Key.from(rCoord));
    }

    public RegionImageSet getRegionImageSet(RegionImageSet.Key rCoordKey) {
        return (RegionImageSet)DataCache.INSTANCE.getRegionImageSets().getUnchecked((Object)rCoordKey);
    }

    public Collection<RegionImageSet> getRegionImageSets() {
        return DataCache.INSTANCE.getRegionImageSets().asMap().values();
    }

    public void updateTextures(boolean forceFlush, boolean async) {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            regionImageSet.finishChunkUpdates();
        }
        if (forceFlush || this.lastFlush + TimeUnit.SECONDS.toMillis(60L) < System.currentTimeMillis()) {
            if (!forceFlush && logger.isEnabled(Level.DEBUG)) {
                logger.debug("RegionImageCache auto-flushing");
            }
            if (async) {
                this.flushToDiskAsync(false);
            } else {
                this.flushToDisk(false);
            }
        }
    }

    public void flushToDiskAsync(boolean force) {
        int count = 0;
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            count += regionImageSet.writeToDiskAsync(force);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    public void flushToDisk(boolean force) {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            regionImageSet.writeToDisk(force);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    public long getLastFlush() {
        return this.lastFlush;
    }

    public List<RegionCoord> getChangedSince(MapType mapType, long time) {
        ArrayList<RegionCoord> list = new ArrayList<RegionCoord>();
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            if (!regionImageSet.updatedSince(mapType, time)) continue;
            list.add(regionImageSet.getRegionCoord());
        }
        if (logger.isEnabled(Level.DEBUG)) {
            logger.debug("Dirty regions: " + list.size() + " of " + DataCache.INSTANCE.getRegionImageSets().size());
        }
        return list;
    }

    public boolean isDirtySince(RegionCoord rc, MapType mapType, long time) {
        RegionImageSet ris = this.getRegionImageSet(rc);
        if (ris == null) {
            return false;
        }
        return ris.updatedSince(mapType, time);
    }

    public void clear() {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            regionImageSet.clear();
        }
        DataCache.INSTANCE.getRegionImageSets().invalidateAll();
        DataCache.INSTANCE.getRegionImageSets().cleanUp();
    }

    public boolean deleteRegion(RegionCoord coord, MapState state) {
        File regionImageFile = RegionImageHandler.getRegionImageFile(coord, state.getMapType());
        Path regionCachePath = RegionDataStorageHandler.getInstance().getFile(coord, state.getMapType());
        DataCache.INSTANCE.getRegionImageSets().invalidate((Object)RegionImageSet.Key.from(coord));
        boolean result = true;
        if (regionImageFile.exists()) {
            FileHandler.delete(regionImageFile);
            logger.info("Deleted region {}: {}", (Object)regionImageFile, (Object)(!regionImageFile.exists() ? 1 : 0));
            if (regionImageFile.exists()) {
                result = false;
            }
        }
        if (regionCachePath != null) {
            File regionCacheFile = regionCachePath.resolve("r." + coord.regionX + "." + coord.regionX + ".mca").toFile();
            FileHandler.delete(regionCacheFile);
            logger.info("Deleted region cache {}: {}", (Object)regionCacheFile, (Object)(!regionCacheFile.exists() ? 1 : 0));
            if (regionCacheFile.exists()) {
                result = false;
            }
        }
        return result;
    }

    public boolean deleteMap(MapState state, boolean allDims) {
        RegionCoord fakeRc = new RegionCoord(state.getWorldDir(), 0, 0, state.getDimension());
        File imageDir = RegionImageHandler.getImageDir(fakeRc, MapType.day(state.getDimension())).getParentFile();
        File[] dirs = allDims ? imageDir.getParentFile().listFiles(new FilenameFilter(this){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && !"waypoints".equals(name);
            }
        }) : new File[]{imageDir};
        if (dirs != null && dirs.length > 0) {
            this.clear();
            boolean result = true;
            for (File dir : dirs) {
                if (!dir.exists()) continue;
                FileHandler.delete(dir);
                logger.info(String.format("Deleted image directory %s: %s", dir, !dir.exists()));
                if (!dir.exists()) continue;
                result = false;
            }
            logger.info("Done deleting directories");
            return result;
        }
        logger.info("Found no DIM directories in " + String.valueOf(imageDir));
        return true;
    }

    static {
        logger = Journeymap.getLogger();
    }
}

