/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pbr.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.irisshaders.iris.mixinterface.AbstractTextureExtended;
import net.irisshaders.iris.pbr.mipmap.CustomMipmapGenerator;
import net.irisshaders.iris.pbr.texture.PBRType;
import net.minecraft.class_1044;
import org.jetbrains.annotations.Nullable;

public interface TextureFormat {
    public String name();

    @Nullable
    public String version();

    default public List<String> getDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        String defineName = this.name().toUpperCase(Locale.ROOT).replaceAll("-", "_");
        String define = "MC_TEXTURE_FORMAT_" + defineName;
        defines.add(define);
        String version = this.version();
        if (version != null) {
            String defineVersion = version.replaceAll("[.-]", "_");
            String versionDefine = define + "_" + defineVersion;
            defines.add(versionDefine);
        }
        return defines;
    }

    public boolean canInterpolateValues(PBRType var1);

    default public void setupTextureParameters(PBRType pbrType, class_1044 texture) {
        if (!this.canInterpolateValues(pbrType)) {
            ((AbstractTextureExtended)texture).setNearestFilter();
        }
    }

    @Nullable
    public CustomMipmapGenerator getMipmapGenerator(PBRType var1);

    public static interface Factory {
        public TextureFormat createFormat(String var1, @Nullable String var2);
    }
}

