/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.config.widgets.CheckBox;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ArmorConfigScreen
extends ConfigScreen {
    private final class_2960 CB_ARM = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/cb_arm.png");
    private final class_2960 CB_MH = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/cb_mh.png");
    private final class_2960 CB_OH = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/cb_oh.png");
    private final class_2960 CB_AR = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/cb_ar.png");
    private final class_2960 CB_INV = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/cb_inv.png");

    public ArmorConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 1, inGame);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        String toggle = InventoryHUD.getConfig().getArm() ? String.valueOf(class_124.field_1077) + "ON" : String.valueOf(class_124.field_1079) + "OFF";
        this.addButton(0, toggle, this::ToggleSwitch);
        this.addNumericField(1, 0, 100, InventoryHUD.getConfig().getArmAbove(), this::AboveChanged, 5);
        this.addCheckbox(2, InventoryHUD.getConfig().isShowArmor(), this::TypeArmorChanged, this.CB_ARM);
        this.addCheckbox(2, 22, InventoryHUD.getConfig().isShowMain(), this::TypeMainHandChanged, this.CB_MH);
        this.addCheckbox(2, 44, InventoryHUD.getConfig().isShowOff(), this::TypeOffHandChanged, this.CB_OH);
        this.addCheckbox(2, 66, InventoryHUD.getConfig().isShowArrows(), this::TypeArrowChanged, this.CB_AR);
        this.addCheckbox(2, 88, InventoryHUD.getConfig().isShowInv(), this::TypeInvChanged, this.CB_INV);
        this.addButton(3, 75, InventoryHUD.getConfig().getArmView().name(), this::ViewSwitch);
        this.addButton(4, Boolean.toString(InventoryHUD.getConfig().getArmBars()), this::BarsSwitch);
        this.addButton(5, Boolean.toString(InventoryHUD.getConfig().getMoveAll()), this::MoveSwitch);
        this.addButton(6, Boolean.toString(InventoryHUD.getConfig().isShowEmpty()), this::EmptySwitch);
        this.addButton(7, Boolean.toString(InventoryHUD.getConfig().isShowCount()), this::ShowCountSwitch);
        float sc = (float)InventoryHUD.getConfig().getArmScale() / 100.0f;
        String t = sc + "x";
        this.addButton(8, t, this::ScaleSwitch);
        this.addButton(9, Boolean.toString(InventoryHUD.getConfig().isShowArrowsWithoutWeapon()), this::ShowArrows);
        this.addButton(10, Boolean.toString(InventoryHUD.getConfig().isArmWithDebug()), this::WithDebug);
        this.addText(10, Translation.WITH_DEBUG.getString(), Translation.ARM_DEBUG_TT);
        this.addText(9, Translation.ARROWS_WITHOUT_WEAPON.getString(), Translation.ARROWS_WITHOUT_WEAPON_TT);
        this.addText(8, Translation.ARM_SCALE.getString(), Translation.ARM_SCALE_TT);
        this.addText(7, Translation.ARM_COUNT.getString(), Translation.ARM_COUNT_TT);
        this.addText(6, Translation.ARM_EMPTY.getString(), Translation.ARM_EMPTY_TT);
        this.addText(5, Translation.ARM_MOVE.getString(), Translation.ARM_MOVE_TT);
        this.addText(4, Translation.ARM_BARS.getString(), Translation.ARM_BARS_TT);
        this.addText(3, Translation.ARM_VIEW.getString(), Translation.ARM_VIEW_TT);
        this.addText(2, Translation.ARM_TYPE.getString(), Translation.ARM_TYPE_TT);
        this.addText(1, Translation.ARM_HIDE.getString(), Translation.ARM_HIDE_TT);
        this.addText(0, Translation.ARM_TOGGLE.getString(), Translation.ARM_TOGGLE_TT);
    }

    private void ShowArrows(ButtonWidget btn) {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArrowsWithoutWeapon = bd = !InventoryHUD.getConfig().isShowArrowsWithoutWeapon();
        InventoryHUD.getConfig().setShowArrowsWithoutWeapon(bd);
        btn.setMessage(Boolean.toString(bd));
    }

    private void WithDebug(ButtonWidget btn) {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.withDebug = bd = !InventoryHUD.getConfig().isArmWithDebug();
        InventoryHUD.getConfig().setArmWithDebug(bd);
        btn.setMessage(Boolean.toString(bd));
    }

    private void ScaleSwitch(ButtonWidget btn) {
        int scale = (int)((InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale * 100.0f + 25.0f) % 175.0f);
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale = (float)scale * 0.01f;
        InventoryHUD.getInstance().getInvhudGUI().changeArmorOffset();
        InventoryHUD.getConfig().setArmScale(scale);
        float sc = (float)scale / 100.0f;
        String t = sc + "x";
        btn.setMessage(t);
    }

    private void ShowCountSwitch(ButtonWidget btn) {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showCount = bd = !InventoryHUD.getConfig().isShowCount();
        InventoryHUD.getConfig().setShowCount(bd);
        btn.setMessage(Boolean.toString(bd));
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getConfig().setShowArmor(cb.checked);
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showMain = cb.checked;
        InventoryHUD.getConfig().setShowMain(cb.checked);
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showOff = cb.checked;
        InventoryHUD.getConfig().setShowOff(cb.checked);
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getConfig().setShowArrows(cb.checked);
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showInv = cb.checked;
        InventoryHUD.getConfig().setShowInv(cb.checked);
    }

    private void AboveChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armAbove = a;
        InventoryHUD.getConfig().setArmAbove(a);
    }

    private void MoveSwitch(ButtonWidget btn) {
        boolean bd = !InventoryHUD.getConfig().getMoveAll();
        InventoryHUD.getInstance().getInvhudGUI().changeMoveAll(bd);
        InventoryHUD.getConfig().setMoveAll(bd);
        btn.setMessage(Boolean.toString(bd));
    }

    private void EmptySwitch(ButtonWidget btn) {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showEmpty = bd = !InventoryHUD.getConfig().isShowEmpty();
        InventoryHUD.getConfig().setShowEmpty(bd);
        btn.setMessage(Boolean.toString(bd));
    }

    private void ViewSwitch(ButtonWidget btn) {
        InvConfig.ArmorView at;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armView = at = (switch (InventoryHUD.getConfig().getArmView()) {
            default -> throw new MatchException(null, null);
            case InvConfig.ArmorView.PERCENTAGE -> InvConfig.ArmorView.DAMAGE;
            case InvConfig.ArmorView.DAMAGE -> InvConfig.ArmorView.DAMAGE_LEFT;
            case InvConfig.ArmorView.DAMAGE_LEFT -> InvConfig.ArmorView.OFF;
            case InvConfig.ArmorView.OFF -> InvConfig.ArmorView.PERCENTAGE;
        });
        InventoryHUD.getConfig().setArmView(at);
        btn.setMessage(at.name());
    }

    private void ToggleSwitch(ButtonWidget btn) {
        boolean armor;
        InventoryHUD.ArmHUD = armor = !InventoryHUD.getConfig().getArm();
        InventoryHUD.getConfig().setArm(armor);
        String armString = armor ? String.valueOf(class_124.field_1077) + "ON" : String.valueOf(class_124.field_1079) + "OFF";
        btn.setMessage(armString);
    }

    private void BarsSwitch(ButtonWidget btn) {
        boolean bars;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armBars = bars = !InventoryHUD.getConfig().getArmBars();
        InventoryHUD.getConfig().setArmBars(bars);
        btn.setMessage(Boolean.toString(bars));
    }
}

