/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.renderer.CheckedBufferSource;
import com.anthonyhilyard.iceberg.renderer.ILayerRenderState;
import com.anthonyhilyard.iceberg.renderer.VertexCollector;
import com.anthonyhilyard.iceberg.util.EntityCollector;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_10366;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_148;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_276;
import net.minecraft.class_2769;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_4013;
import net.minecraft.class_4059;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_6364;
import net.minecraft.class_7225;
import net.minecraft.class_773;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.minecraft.class_9323;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomItemRenderer
extends class_918
implements class_4013 {
    private static CustomItemRenderer INSTANCE = null;
    public static boolean swapFrameBuffer = false;
    public static class_276 iconFrameBuffer = null;
    private static class_1531 armorStand = null;
    private static class_1493 wolf = null;
    private static class_1498 horse = null;
    private static class_1297 entity = null;
    private static Pair<class_1792, class_9323> cachedArmorStandItem = null;
    private static Pair<class_1792, class_9323> cachedHorseArmorItem = null;
    private static Pair<class_1792, class_9323> cachedWolfArmorItem = null;
    private static Pair<class_1792, class_9323> cachedEntityItem = null;
    private static Map<Pair<class_1792, class_9323>, ModelBounds> modelBoundsCache = Maps.newHashMap();
    private static Map<class_1087, Boolean> testedModels = Maps.newHashMap();
    private class_310 minecraft;
    private final class_1092 modelManager;
    private static int[] tints = new int[0];

    public static CustomItemRenderer getInstance() {
        if (INSTANCE == null) {
            class_310 minecraft = class_310.method_1551();
            INSTANCE = new CustomItemRenderer(minecraft, minecraft.method_1554(), minecraft.method_65386());
        }
        return INSTANCE;
    }

    @Deprecated(forRemoval=true, since="1.2.12")
    public CustomItemRenderer(class_310 mcIn, class_1092 modelManagerIn, class_10442 itemModelResolver) {
        super(itemModelResolver);
        this.minecraft = mcIn;
        this.modelManager = modelManagerIn;
    }

    private void renderGuiModel(class_1799 itemStack, int x, int y, Quaternionf rotation, class_332 graphics) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        modelViewStack.mul((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.disableDepthTest();
        graphics.method_64039(bufferSource -> this.renderModel(itemStack, class_811.field_4317, false, new class_4587(), rotation, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444));
        RenderSystem.enableDepthTest();
        modelViewStack.popMatrix();
    }

    private void renderEntityModel(class_1297 entity, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_310 minecraft = class_310.method_1551();
        class_898 entityRenderDispatcher = minecraft.method_1561();
        class_308.method_34742();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityRenderDispatcher.method_3948(false);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        try {
            RenderSystem.recordRenderCall(() -> entityRenderDispatcher.method_62424(entity, 0.0, 0.0, 0.0, 0.0f, poseStack, bufferSource, packedLight));
            RenderSystem.replayQueue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.method_22909();
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        entityRenderDispatcher.method_3948(true);
        class_308.method_24211();
    }

    private <T extends class_4597> void renderModelInternal(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, T bufferSource, int packedLight, int packedOverlay, Predicate<T> bufferSourceReady) {
        class_1792 class_17922;
        class_310 minecraft = class_310.method_1551();
        if (ItemUtil.getEquipmentSlot(itemStack).method_46643() && this.updateArmorStand(itemStack)) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            this.renderEntityModel((class_1297)armorStand, poseStack, bufferSource, packedLight);
            poseStack.method_22909();
        }
        if (bufferSourceReady.test(bufferSource) && (class_17922 = itemStack.method_7909()) instanceof class_1747) {
            class_2248 class_22482;
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            class_1087 blockModel = null;
            class_773 blockModelShaper = minecraft.method_1541().method_3351();
            boolean isBlockEntity = false;
            blockModel = blockModelShaper.method_3335(block.method_9564());
            if (blockModel == this.modelManager.method_4744()) {
                blockModel = minecraft.method_1554().method_4742(class_773.method_3340((class_2680)blockItem.method_7711().method_9564()));
            }
            if (blockModel == this.modelManager.method_4744()) {
                blockModel = null;
            }
            if (block.method_9564().method_28498((class_2769)class_2741.field_12533)) {
                class_2680 bottomState = (class_2680)block.method_9564().method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
                class_1087 bottomModel = blockModelShaper.method_3335(bottomState);
                this.renderBakedModelSafe(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bottomModel);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 1.0f, 0.0f);
                class_2680 topState = (class_2680)block.method_9564().method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                class_1087 topModel = blockModelShaper.method_3335(topState);
                this.renderBakedModelSafe(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, topModel);
                poseStack.method_22909();
            }
            if ((class_22482 = blockItem.method_7711()) instanceof class_2343) {
                class_2343 entityBlock = (class_2343)class_22482;
                isBlockEntity = true;
                try {
                    this.renderBlockEntity(itemStack, poseStack, bufferSource, packedLight, packedOverlay, minecraft, entityBlock, blockItem.method_7711().method_9564());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (blockModel != null && (bufferSourceReady.test(bufferSource) || isBlockEntity)) {
                this.renderBakedModelSafe(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, blockModel);
            }
        }
        if (minecraft.field_1687 != null && bufferSourceReady.test(bufferSource) && EntityCollector.itemCreatesEntity(itemStack, class_1297.class, (class_7225.class_7874)minecraft.field_1687.method_30349()) && this.updateEntity(itemStack)) {
            this.renderEntityModel(entity, poseStack, bufferSource, packedLight);
        }
        if (bufferSourceReady.test(bufferSource) && (class_17922 = itemStack.method_7909()) instanceof class_4059) {
            class_4059 animalArmor = (class_4059)class_17922;
            switch (animalArmor.field_47824) {
                case field_47825: {
                    if (!this.updateHorseArmor(itemStack)) break;
                    this.renderEntityModel((class_1297)horse, poseStack, bufferSource, packedLight);
                    break;
                }
                case field_47826: {
                    if (!this.updateWolfArmor(itemStack)) break;
                    this.renderEntityModel((class_1297)wolf, poseStack, bufferSource, packedLight);
                }
            }
        }
        if (bufferSourceReady.test(bufferSource)) {
            displayContext = class_811.field_4321;
            this.renderModelNoTransform(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private class_804 getItemTransform(class_1799 itemStack, class_811 displayContext) {
        this.field_55296.method_65598(this.field_55297, itemStack, displayContext, false, null, null, 0);
        return this.field_55297.method_65609();
    }

    private void renderModel(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, Quaternionf rotation, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (!itemStack.method_7960()) {
            class_310 minecraft = class_310.method_1551();
            class_811 previewContext = displayContext;
            class_804 itemTransform = this.getItemTransform(itemStack, previewContext);
            boolean isBlockItem = false;
            boolean spawnsEntity = false;
            boolean isArmor = false;
            if (itemStack.method_7909() instanceof class_1747) {
                isBlockItem = true;
                if (itemTransform != class_804.field_4284) {
                    previewContext = class_811.field_4318;
                    itemTransform = this.getItemTransform(itemStack, previewContext);
                }
            } else if (minecraft.field_1687 != null && EntityCollector.itemCreatesEntity(itemStack, class_1297.class, (class_7225.class_7874)minecraft.field_1687.method_30349())) {
                spawnsEntity = true;
            }
            if (ItemUtil.getEquipmentSlot(itemStack).method_46643()) {
                isArmor = true;
            }
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                itemTransform.method_23075(leftHanded, poseStack);
            }
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            ModelBounds modelBounds = this.getModelBounds(itemStack, previewContext, leftHanded, poseStack, rotation, packedLight, packedOverlay);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22907(rotation);
            float scale = 0.8f / Math.max(modelBounds.height, modelBounds.radius * 2.0f);
            if (isArmor) {
                switch (ItemUtil.getEquipmentSlot(itemStack)) {
                    case field_6169: {
                        scale *= 0.75f;
                        break;
                    }
                    case field_6172: {
                        scale *= 1.3f;
                        break;
                    }
                    case field_6166: {
                        scale *= 0.85f;
                        break;
                    }
                }
            }
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_46416(-modelBounds.center.x(), -modelBounds.center.y(), -modelBounds.center.z());
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                itemTransform.method_23075(leftHanded, poseStack);
            }
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            CheckedBufferSource checkedBufferSource = CheckedBufferSource.create(bufferSource);
            this.renderModelInternal(itemStack, previewContext, leftHanded, poseStack, checkedBufferSource, packedLight, packedOverlay, b -> !b.hasRendered());
            poseStack.method_22909();
        }
    }

    private void renderBlockEntity(class_1799 itemStack, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_310 minecraft, class_2343 entityBlock, class_2680 blockState) throws Exception {
        class_2586 blockEntity = entityBlock.method_10123(class_2338.field_10980, blockState);
        if (blockEntity != null) {
            blockEntity.method_58683(itemStack);
            class_827 renderer = minecraft.method_31975().method_3550(blockEntity);
            if (renderer != null) {
                renderer.method_3569(blockEntity, minecraft.method_61966().method_60638(), poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    private void renderBakedModelSafe(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel) {
        if (!testedModels.containsKey(bakedModel)) {
            try {
                this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bakedModel);
                testedModels.put(bakedModel, true);
            }
            catch (Exception e) {
                testedModels.put(bakedModel, false);
            }
        } else if (testedModels.get(bakedModel).booleanValue()) {
            this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bakedModel);
        }
    }

    private void renderBakedModel(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel) {
        class_1921 renderType = class_4696.method_23678((class_1799)itemStack);
        CustomItemRenderer.method_62476((class_811)displayContext, (class_4587)poseStack, (class_4597)bufferSource, (int)packedLight, (int)packedOverlay, (int[])tints, (class_1087)bakedModel, (class_1921)renderType, (class_10444.class_10445)class_10444.class_10445.field_55341);
    }

    private void renderModelNoTransform(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, int packedOverlay) {
        boolean flatLighting;
        this.field_55296.method_65598(this.field_55297, itemStack, displayContext, false, null, null, 0);
        boolean bl = flatLighting = !this.field_55297.method_65608();
        if (flatLighting) {
            if (multiBufferSource instanceof class_4597.class_4598) {
                class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
                bufferSource.method_22993();
            }
            class_308.method_24210();
        }
        for (int k = 0; k < this.field_55297.field_55339; ++k) {
            ILayerRenderState layer = (ILayerRenderState)this.field_55297.field_55340[k];
            layer.renderWithoutTransform(poseStack, displayContext, multiBufferSource, packedLight, packedOverlay);
        }
        if (multiBufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
            bufferSource.method_22993();
        }
        if (flatLighting) {
            class_308.method_24211();
        }
    }

    private boolean updateArmorStand(class_1799 itemStack) {
        class_1304 equipmentSlot = ItemUtil.getEquipmentSlot(itemStack);
        if (!equipmentSlot.method_46643()) {
            return false;
        }
        if (armorStand == null) {
            class_310 minecraft = class_310.method_1551();
            armorStand = (class_1531)class_1299.field_6131.method_5883((class_1937)minecraft.field_1687, class_3730.field_16462);
            armorStand.method_5648(true);
        }
        if (armorStand == null) {
            return false;
        }
        if (cachedArmorStandItem != Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemComponents(itemStack))) {
            for (class_1304 slot : class_1304.values()) {
                armorStand.method_5673(slot, class_1799.field_8037);
            }
            armorStand.method_5673(equipmentSlot, itemStack);
            cachedArmorStandItem = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemComponents(itemStack));
        }
        return true;
    }

    private class_1297 getEntityFromItem(class_1799 itemStack) {
        List collectedEntities;
        class_310 minecraft = class_310.method_1551();
        class_1297 collectedEntity = null;
        List<Object> list = collectedEntities = minecraft.field_1687 == null ? List.of() : EntityCollector.collectEntitiesFromItem(itemStack, (class_7225.class_7874)minecraft.field_1687.method_30349());
        if (!collectedEntities.isEmpty()) {
            collectedEntity = (class_1297)collectedEntities.get(0);
        }
        return collectedEntity;
    }

    private boolean updateEntity(class_1799 itemStack) {
        Pair entityItem = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemComponents(itemStack));
        if (entity == null || cachedEntityItem != entityItem) {
            entity = this.getEntityFromItem(itemStack);
            cachedEntityItem = entityItem;
        }
        return entity != null;
    }

    private boolean updateHorseArmor(class_1799 horseArmorItem) {
        block7: {
            block6: {
                class_1792 class_17922 = horseArmorItem.method_7909();
                if (!(class_17922 instanceof class_4059)) break block6;
                class_4059 animalArmor = (class_4059)class_17922;
                if (animalArmor.field_47824 == class_4059.class_9076.field_47825) break block7;
            }
            return false;
        }
        if (horse == null) {
            class_310 minecraft = class_310.method_1551();
            horse = (class_1498)class_1299.field_6139.method_5883((class_1937)minecraft.field_1687, class_3730.field_16462);
            horse.method_5648(true);
        }
        if (horse == null) {
            return false;
        }
        if (cachedHorseArmorItem != Pair.of((Object)horseArmorItem.method_7909(), (Object)ItemUtil.getItemComponents(horseArmorItem))) {
            horse.method_56678(horseArmorItem);
            cachedHorseArmorItem = Pair.of((Object)horseArmorItem.method_7909(), (Object)ItemUtil.getItemComponents(horseArmorItem));
        }
        return true;
    }

    private boolean updateWolfArmor(class_1799 wolfArmorItem) {
        block7: {
            block6: {
                class_1792 class_17922 = wolfArmorItem.method_7909();
                if (!(class_17922 instanceof class_4059)) break block6;
                class_4059 animalArmor = (class_4059)class_17922;
                if (animalArmor.field_47824 == class_4059.class_9076.field_47826) break block7;
            }
            return false;
        }
        if (wolf == null) {
            class_310 minecraft = class_310.method_1551();
            wolf = (class_1493)class_1299.field_6055.method_5883((class_1937)minecraft.field_1687, class_3730.field_16462);
            wolf.method_5648(true);
        }
        if (wolf == null) {
            return false;
        }
        if (cachedWolfArmorItem != Pair.of((Object)wolfArmorItem.method_7909(), (Object)ItemUtil.getItemComponents(wolfArmorItem))) {
            wolf.method_56678(wolfArmorItem);
            cachedWolfArmorItem = Pair.of((Object)wolfArmorItem.method_7909(), (Object)ItemUtil.getItemComponents(wolfArmorItem));
        }
        return true;
    }

    private ModelBounds boundsFromVertices(Set<Vector3f> vertices) {
        Vector3f center = new Vector3f();
        float radius = 0.0f;
        float height = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Vector3f vertex : vertices) {
            minX = Math.min(minX, vertex.x);
            minY = Math.min(minY, vertex.y);
            minZ = Math.min(minZ, vertex.z);
            maxX = Math.max(maxX, vertex.x);
            maxY = Math.max(maxY, vertex.y);
            maxZ = Math.max(maxZ, vertex.z);
        }
        center = new Vector3f((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
        height = maxY - minY;
        for (Vector3f vertex : vertices) {
            radius = Math.max(radius, (float)Math.sqrt((vertex.x - center.x) * (vertex.x - center.x) + (vertex.z - center.z) * (vertex.z - center.z)));
        }
        return new ModelBounds(center, height, radius);
    }

    private ModelBounds getModelBounds(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, Quaternionf rotation, int packedLight, int packedOverlay) {
        Pair key = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemComponents(itemStack));
        if (!modelBoundsCache.containsKey(key)) {
            VertexCollector vertexCollector = VertexCollector.create();
            this.renderModelInternal(itemStack, displayContext, leftHanded, poseStack, vertexCollector, packedLight, packedOverlay, b -> b.getVertices().isEmpty());
            modelBoundsCache.put((Pair<class_1792, class_9323>)key, this.boundsFromVertices(vertexCollector.getVertices()));
        }
        return modelBoundsCache.get(key);
    }

    public void renderDetailModelIntoGUI(class_1799 stack, int x, int y, Quaternionf rotation, class_332 graphics) {
        try {
            this.renderGuiModel(stack, x, y, rotation, graphics);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
            class_129 crashReportCategory = crashReport.method_562("Item being rendered");
            crashReportCategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
            crashReportCategory.method_577("Item Components", () -> String.valueOf(stack.method_57353()));
            crashReportCategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
            throw new class_148(crashReport);
        }
    }

    public void renderItemModelIntoGUIWithAlpha(class_332 graphics, class_1799 stack, int x, int y, float alpha) {
        boolean flatLighting;
        if (iconFrameBuffer == null) {
            iconFrameBuffer = new class_6364(96, 96);
            iconFrameBuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        }
        class_276 lastFrameBuffer = this.minecraft.method_1522();
        iconFrameBuffer.method_1230();
        iconFrameBuffer.method_1235(true);
        Matrix4f matrix = new Matrix4f();
        matrix.setOrtho(0.0f, (float)CustomItemRenderer.iconFrameBuffer.field_1482, (float)CustomItemRenderer.iconFrameBuffer.field_1481, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (class_10366)class_10366.field_54954);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        modelViewStack.translate(48.0f, 48.0f, -2000.0f);
        modelViewStack.scale(96.0f, 96.0f, 96.0f);
        swapFrameBuffer = true;
        this.field_55296.method_65598(this.field_55297, stack, class_811.field_4317, false, null, null, 0);
        boolean bl = flatLighting = !this.field_55297.method_65608();
        if (flatLighting) {
            graphics.method_51452();
            class_308.method_24210();
        }
        graphics.method_64039(bufferSource -> this.field_55297.method_65604(new class_4587(), bufferSource, 0xF000F0, class_4608.field_21444));
        if (flatLighting) {
            class_308.method_24211();
        }
        swapFrameBuffer = false;
        modelViewStack.popMatrix();
        RenderSystem.restoreProjectionMatrix();
        if (lastFrameBuffer != null) {
            lastFrameBuffer.method_1235(true);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.setShaderTexture((int)0, (int)iconFrameBuffer.method_30277());
            GuiHelper.blit(graphics.method_51448(), x, y, 16, 16, 0.0f, 0.0f, CustomItemRenderer.iconFrameBuffer.field_1482, CustomItemRenderer.iconFrameBuffer.field_1481, CustomItemRenderer.iconFrameBuffer.field_1482, CustomItemRenderer.iconFrameBuffer.field_1481);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_51452();
            iconFrameBuffer.method_1242();
        } else {
            iconFrameBuffer.method_1240();
        }
    }

    public void method_14491(class_3300 resourceManager) {
        modelBoundsCache.clear();
    }

    private record ModelBounds(Vector3f center, float height, float radius) {
    }
}

